﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Ksiega" %>
<script runat="server">

	public class Params: ContextBase {
	
		public Params(Context context): base(context) {
		}

		bool nadajPrawa = false;
		[Caption("Inicjuj prawa def. ewid.")]
    public bool NadajPrawa {
      get { return nadajPrawa; }
			set {
        nadajPrawa = value; 
				OnChanged(EventArgs.Empty);
			}
		}

    AccessRights prawo = AccessRights.ReadOnly;
    [Caption("Prawo")]    
    public AccessRights Prawo {
      get { return prawo; }
      set { prawo = value; }
    }

    public AccessRights[] GetListPrawo() {
      return new AccessRights[] { AccessRights.Granted, AccessRights.ReadOnly, AccessRights.Denied };
    }
	}

	Params pars;
	[Context]
	public Params Pars {
		get { return pars; }
		set { pars = value; }
	}

    void dc_ContextLoad(Object sender, EventArgs e) {
      if (!pars.NadajPrawa)
        throw new CancelException();

      using (Session s = pars.Session.Login.CreateSession(false, true)) {
        using (Soneta.Business.ITransaction t = s.Logout(true)) {
          Soneta.Business.Db.BusinessModule bus = Soneta.Business.Db.BusinessModule.GetInstance(s);
          foreach (Soneta.Core.DefinicjaDokumentu dd in Soneta.Core.CoreModule.GetInstance(s).DefDokumentow) {
            Soneta.Core.DokEwidencji.DefEwidencji de = dd as Soneta.Core.DokEwidencji.DefEwidencji;
            if (de == null)
              continue;
            foreach (Soneta.Business.Db.Right right in bus.Rights.WgSource[de]) {
              right.Delete();
            }

            if (pars.Prawo == AccessRights.ReadOnly || pars.Prawo == AccessRights.Granted) {
              foreach (Soneta.Business.App.Entitle ent in bus.Entitles) {
                if (pars.Prawo == AccessRights.Granted)
                  bus.Rights.AddRow(new Soneta.Business.Db.Right(ent, de, false));
                else
                  bus.Rights.AddRow(new Soneta.Business.Db.Right(ent, de, true));
              }
            }



          }


          t.Commit();
        }
        s.Save();
      }
				
		throw new CancelException();
    }
    
	static void Msg(object value) {
	}

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Nadawanie praw do definicji ewidencji dokumentów</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    </form>
</body>
</html>
